/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.furniture;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.furniture.FurnitureEntityAssetsByLayout;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureCategoryDictionary;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureLayoutDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureCategory;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;

public class FurnitureEntityAssetsByCategory {
    private Map<String, FurnitureEntityAssetsByLayout> byCategoryName = new HashMap<String, FurnitureEntityAssetsByLayout>();

    public FurnitureEntityAssetsByCategory(FurnitureCategoryDictionary categoryDictionary, FurnitureLayoutDictionary layoutDictionary) {
        for (FurnitureCategory category : categoryDictionary.getAll()) {
            this.byCategoryName.put(category.getName(), new FurnitureEntityAssetsByLayout(layoutDictionary));
        }
    }

    public void add(FurnitureEntityAsset asset) {
        String categoryName = asset.getFurnitureCategoryName();
        if (categoryName == null) {
            throw new RuntimeException("Category name must be specified for " + asset);
        }
        this.byCategoryName.get(categoryName).add(asset);
    }

    public FurnitureEntityAsset get(FurnitureEntityAttributes attributes) {
        String categoryName = attributes.getFurnitureType().getFurnitureCategory().getName();
        return this.byCategoryName.get(categoryName).get(attributes);
    }

    public List<FurnitureEntityAsset> getAll(FurnitureEntityAttributes attributes) {
        String categoryName = attributes.getFurnitureType().getFurnitureCategory().getName();
        return this.byCategoryName.get(categoryName).getAll(attributes);
    }
}

